#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "common.h"
#include "error.h"
#include "tree.h"
#include "printTree.h"

#define TAB_SIZE 3

CPrintTree::CPrintTree()
{
	m_printtolog = false;
}

void CPrintTree::indentprintHTML(unsigned int indent,const char* format,...)
{
	if (m_printtolog)
	{
		va_list	arguments;
		FILE* pFile = theLog.GetFile();

		for (unsigned int i = 0; i < indent;i++)
			fprintf(pFile,"&nbsp&nbsp&nbsp");

		va_start(arguments,format);
		vfprintf(pFile,format,arguments);
		va_end(arguments);
	}
}

//**********************************************************************************************************************
void CPrintTree::Process(SCRIPT* theScript)
{
	indentprintHTML(0,"SCRIPT:<br>");
	indentprintHTML(0,"->toplevels:<br>");

	if (theScript->toplevels)
		processTOPLEVEL(1,theScript->toplevels);
}

void CPrintTree::processTOPLEVEL(int indent, TOPLEVEL* toplevel)
{
	indentprintHTML(indent,"TOPLEVEL:<br>");
	indentprintHTML(indent,"->function:<br>");

	if (toplevel->function)
		processFUNCTION(indent + 1, toplevel->function);

	indentprintHTML(indent,"->next:<br>");

	if (toplevel->next)
		processTOPLEVEL(indent,	toplevel->next);
}

void CPrintTree::processFUNCTION(int indent, FUNCTION* function)
{
	indentprintHTML(indent,"FUNCTION:<br>");
	indentprintHTML(indent,"->name: %s<br>",function->name);

	switch (function->kind)
	{
	case localT:
		indentprintHTML(indent,"->kind = localT<br>");
		indentprintHTML(indent,"->declaration:<br>");
		if (function->declaration)
			processDECLARATION(indent + 1,function->declaration);
		indentprintHTML(indent,"->statements:<br>");
		if (function->statements)
			processSTATEMENT(indent + 1, function->statements);
		break;
	case externT:
		indentprintHTML(indent,"->kind = externT<br>");
		indentprintHTML(indent,"->library = %s<br>",function->library);
		break;
	}
}

void CPrintTree::processDECLARATION(int indent, DECLARATION* declaration)
{
	indentprintHTML(indent,"DECLARATION:<br>");

	switch (declaration->kind)
	{
	case formalT:
		indentprintHTML(indent,"->kind = formalD<br>");
		indentprintHTML(indent,"->name = %s<br>",declaration->val.formalD.name);
		break;
	case variableT:
		indentprintHTML(indent,"->kind = variableT<br>");

		indentprintHTML(indent,"->identifiers:<br>");
		if (declaration->val.variableD.identifiers)
			processIDENTIFIER(indent + 1,declaration->val.variableD.identifiers);
		indentprintHTML(indent,"->initialization:<br>");
		if (declaration->val.variableD.initialization)
			processEXPRESSION(indent + 1,declaration->val.variableD.initialization);
		break;
	case simplevarT:
		indentprintHTML(indent,"->kind = simplevarT<br>");
		indentprintHTML(indent,"->name = %s<br>",declaration->val.simplevarD.name);
		indentprintHTML(indent,"->initialization:<br>");
		if (declaration->val.simplevarD.initialization)
			processEXPRESSION(indent + 1,declaration->val.simplevarD.initialization);
		break;
	}

	indentprintHTML(indent,"->next:<br>");

	if (declaration->next)
		processDECLARATION(indent + 1,declaration->next);
}

void CPrintTree::processIDENTIFIER(int indent,IDENTIFIER* identifier)
{
	indentprintHTML(indent,"IDENTIFIER:<br>");
	indentprintHTML(indent,"->name = %s<br>",identifier->name);
	indentprintHTML(indent,"->next:<br>");
	if (identifier->next)
		processIDENTIFIER(indent + 1,identifier->next);
}

void CPrintTree::processFORINIT(int indent, FORINIT* forinit)
{
	indentprintHTML(indent,"FORINIT:<br>");

	switch (forinit->kind)
	{
	case declarationforinitT:
		indentprintHTML(indent,"->kind = declarationforinitT<br>");
		indentprintHTML(indent,"->declaration:<br>");
		processDECLARATION(indent + 1, forinit->val.declarationF);
		break;
	case expressionforinitT:
		indentprintHTML(indent,"->kind = expressionforinitT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processEXPRESSION(indent + 1, forinit->val.expressionF);
		break;
	}

	indentprintHTML(indent,"->next:<br>");

	if (forinit->next)
		processFORINIT(indent + 1,forinit->next);
}

void CPrintTree::processSTATEMENT(int indent, STATEMENT* statement)
{
	indentprintHTML(indent,"STATEMENT:<br>");

	switch (statement->kind)
	{
	case skipT:
		indentprintHTML(indent,"kind = skipT<br>");
		break;
	case returnT:
		indentprintHTML(indent,"->kind = returnT<br>");
		indentprintHTML(indent,"->expression:<br>");
		if (statement->val.returnS.expression)
			processEXPRESSION(indent + 1,statement->val.returnS.expression);
		break;
	case declstmT:
		indentprintHTML(indent,"->kind = declstmT<br>");
		indentprintHTML(indent,"->declaration:<br>");
		processDECLARATION(indent + 1, statement->val.declaration);
		break;
	case expT:
		indentprintHTML(indent,"->kind = expT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processEXPRESSION(indent + 1, statement->val.expression);
		break;
	case ifT:
		indentprintHTML(indent,"->kind = ifT<br>");
		indentprintHTML(indent,"->condition:<br>");
		processEXPRESSION(indent + 1, statement->val.ifS.condition);
		indentprintHTML(indent,"->body:<br>");
		processSTATEMENT(indent + 1, statement->val.ifS.body);
		break;
	case ifelseT:
		indentprintHTML(indent,"->kind = ifelseT<br>");
		indentprintHTML(indent,"->condition:<br>");
		processEXPRESSION(indent + 1, statement->val.ifelseS.condition);
		indentprintHTML(indent,"->ifbody:<br>");
		processSTATEMENT(indent + 1, statement->val.ifelseS.ifbody);
		indentprintHTML(indent,"->elsebody:<br>");
		processSTATEMENT(indent + 1, statement->val.ifelseS.elsebody);
		break;
	case forT:
		indentprintHTML(indent,"->kind = forT<br>");
		indentprintHTML(indent,"->initialization:<br>");
		processFORINIT(indent + 1, statement->val.forS.inits);
		indentprintHTML(indent,"->condition:<br>");
		processEXPRESSION(indent + 1, statement->val.forS.condition);
		indentprintHTML(indent,"->updates:<br>");
		processEXPRESSION(indent + 1, statement->val.forS.updates);
		indentprintHTML(indent,"->body:<br>");
		processSTATEMENT(indent + 1, statement->val.forS.body);
		break;
	case whileT:
		indentprintHTML(indent,"->kind = whileT<br>");
		indentprintHTML(indent,"->condition:<br>");
		processEXPRESSION(indent + 1, statement->val.whileS.condition);
		indentprintHTML(indent,"->body:<br>");
		processSTATEMENT(indent + 1, statement->val.whileS.body);
		break;
	case scopeT:
		indentprintHTML(indent,"->kind = scopeT<br>");
		indentprintHTML(indent,"->statements:<br>");
		processSTATEMENT(indent + 1, statement->val.scopeS.statement);
		break;
	case sequenceT:
		indentprintHTML(indent,"->kind = sequenceT<br>");
		indentprintHTML(indent,"->first:<br>");
		processSTATEMENT(indent + 1, statement->val.sequenceS.firts);
		indentprintHTML(indent,"->second:<br>");
		processSTATEMENT(indent + 1, statement->val.sequenceS.second);
		break;
	}
}

void CPrintTree::processEXPRESSION(int indent, EXPRESSION* expression)
{
	if (!expression)
		return;

	indentprintHTML(indent,"EXPRESSION:<br>");

	switch (expression->kind)
	{
	case intconstT:
		indentprintHTML(indent,"->kind = intconstT<br>");
		indentprintHTML(indent,"->value = %i<br>",expression->val.intconstE);
		break;
	case stringconstT:
		indentprintHTML(indent,"->kind = stringconstT<br>");
		indentprintHTML(indent,"->value = %s<br>",expression->val.stringconstE);
		break;
	case doubleconstT:
		indentprintHTML(indent,"->kind = doubleconstT<br>");
		indentprintHTML(indent,"->value = %f<br>",expression->val.doubleconstE);
		break;
	case notT:
		indentprintHTML(indent,"->kind = notT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processEXPRESSION(indent + 1,expression->val.notE.expression);
		break;
	case uminusT:
		indentprintHTML(indent,"->kind = uminusT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processEXPRESSION(indent + 1,expression->val.uminusE);
		break;
	case lvalueT:
		indentprintHTML(indent,"->kind = lvalueT<br>");
		processLVALUE(indent + 1,expression->val.lvalue);
		break;
	case assignmentT:
		indentprintHTML(indent,"->kind = '='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.assignmentE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.assignmentE.right);
		break;
	case equalsT:
		indentprintHTML(indent,"->kind = '=='<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1,expression->val.equalsE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.equalsE.right);
		break;
	case nequalsT:
		indentprintHTML(indent,"->kind = '!='<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1,expression->val.nequalsE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.nequalsE.right);
		break;
	case lessT:
		indentprintHTML(indent,"->kind = '<'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1,expression->val.lessE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.lessE.right);
		break;
	case greaterT:
		indentprintHTML(indent,"->kind = '>'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.greaterE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.greaterE.right);
		break;
	case lequalsT:
		indentprintHTML(indent,"->kind = '<='<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.lequalsE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.lequalsE.right);
		break;
	case gequalsT:
		indentprintHTML(indent,"->kind = '>='<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.gequalsE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.gequalsE.right);
		break;
	case plusT:
		indentprintHTML(indent,"->kind = '+'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.plusE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.plusE.right);
		break;
	case minusT:
		indentprintHTML(indent,"->kind = '-'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.minusE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.minusE.right);
		break;
	case mulT:
		indentprintHTML(indent,"->kind = '*'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.mulE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.mulE.right);
		break;
	case divT:
		indentprintHTML(indent,"->kind = '/'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.divE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.divE.right);
		break;
	case modT:
		indentprintHTML(indent,"->kind = '%%'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.modE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.modE.right);
		break;
	case andT:
		indentprintHTML(indent,"->kind = '&&'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.andE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.andE.right);
		break;
	case orT:
		indentprintHTML(indent,"->kind = '||'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.orE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.orE.right);
		break;
	case callT:
		indentprintHTML(indent,"->kind = callT<br>");
		indentprintHTML(indent,"->function = %s<br>",expression->val.callE.name);
		indentprintHTML(indent,"->arguments:<br>");
		processEXPRESSION(indent + 1,expression->val.callE.arguments);
		break;
	case plusassignT:
		indentprintHTML(indent,"->kind = '+='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.plusassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.plusassignE.right);
		break;
	case minusassignT:
		indentprintHTML(indent,"->kind = '-='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.minusassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.minusassignE.right);
		break;
	case mulassignT:
		indentprintHTML(indent,"->kind = '*='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.mulassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.mulassignE.right);
		break;
	case divassignT:
		indentprintHTML(indent,"->kind = '/='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.divassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.divassignE.right);
		break;
	case modassignT:
		indentprintHTML(indent,"->kind = '%%='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.modassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.modassignE.right);
		break;
	case shlassignT:
		indentprintHTML(indent,"->kind = '<<='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.shlassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.shlassignE.right);
		break;
	case shrassignT:
		indentprintHTML(indent,"->kind = '>>='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.shrassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.shrassignE.right);
		break;
	case andassignT:
		indentprintHTML(indent,"->kind = '&='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.andassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.andassignE.right);
		break;
	case orassignT:
		indentprintHTML(indent,"->kind = '|='<br>");
		indentprintHTML(indent,"->left:<br>");
		processLVALUE(indent + 1,expression->val.orassignE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.orassignE.right);
		break;
	case shlT:
		indentprintHTML(indent,"->kind = '<<'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.shlE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.shlE.right);
		break;
	case shrT:
		indentprintHTML(indent,"->kind = '>>'<br>");
		indentprintHTML(indent,"->left:<br>");
		processEXPRESSION(indent + 1, expression->val.shrE.left);
		indentprintHTML(indent,"->right:<br>");
		processEXPRESSION(indent + 1,expression->val.shrE.right);
		break;
	case postincT:
		indentprintHTML(indent,"->kind = postincT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processLVALUE(indent + 1,expression->val.incE);
		break;
	case prefincT:
		indentprintHTML(indent,"->kind = prefincT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processLVALUE(indent + 1,expression->val.incE);
		break;
	case postdecT:
		indentprintHTML(indent,"->kind = postdecT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processLVALUE(indent + 1,expression->val.decE);
		break;
	case prefdecT:
		indentprintHTML(indent,"->kind = prefdecT<br>");
		indentprintHTML(indent,"->expression:<br>");
		processLVALUE(indent + 1,expression->val.decE);
		break;
	}

	indentprintHTML(indent,"->next:<br>");
	if (expression->next)
		processEXPRESSION(indent, expression->next);

	return;
}

void CPrintTree::processLVALUE(int indent, LVALUE* lvalue)
{
	indentprintHTML(indent,"LVALUE:<br>");
	switch (lvalue->kind)
	{
	case identifierT:
		indentprintHTML(indent,"->kind = identifierT<br>");
		indentprintHTML(indent,"->name = %s<br>",lvalue->val.idL);
		break;
	}
}